/*
 * Decompiled with CFR 0.152.
 */
package cloud.lemonslice.teastory.client.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;
import org.joml.Matrix4f;

public class RenderUtil {
    public static void buildMatrix(Matrix4f matrix, VertexConsumer builder, float x, float y, float z, float u, float v, int overlay, int RGBA, float alpha, int light) {
        float red = (float)(RGBA >> 16 & 0xFF) / 255.0f;
        float green = (float)(RGBA >> 8 & 0xFF) / 255.0f;
        float blue = (float)(RGBA & 0xFF) / 255.0f;
        builder.m_252986_(matrix, x, y, z).m_85950_(red, green, blue, alpha).m_7421_(u, v).m_86008_(overlay).m_85969_(light).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
    }

    public static void buildMatrix(Matrix4f matrix, VertexConsumer builder, float x, float y, float z, float u, float v, int RGBA) {
        float red = (float)(RGBA >> 16 & 0xFF) / 255.0f;
        float green = (float)(RGBA >> 8 & 0xFF) / 255.0f;
        float blue = (float)(RGBA >> 0 & 0xFF) / 255.0f;
        boolean alpha = true;
        builder.m_252986_(matrix, x, y, z).m_85950_(red, green, blue, (float)alpha).m_7421_(u, v).m_5752_();
    }

    public static TextureAtlasSprite getBlockSprite(ResourceLocation sprite) {
        return Minecraft.m_91087_().m_91304_().m_119428_(InventoryMenu.f_39692_).m_118316_(sprite);
    }

    public static void renderFluidStackInGUI(GuiGraphics matrixStack, int mouseX, int mouseY, int capacity, FluidStack fluid, int startX, int startY, int totalHeight) {
        int height = 0;
        if (capacity != 0) {
            height = (int)Math.ceil((float)totalHeight * (float)fluid.getAmount() / (float)capacity);
        }
        PoseStack poseStack = matrixStack.m_280168_();
        poseStack.m_85836_();
        if (!fluid.isEmpty()) {
            RenderUtil.renderFluidStackInGUI(matrixStack.m_280168_().m_85850_().m_252922_(), fluid, 16, height, startX, startY + totalHeight);
            if (startX < mouseX && mouseX < startX + 16 && startY < mouseY && mouseY < startY + totalHeight) {
                matrixStack.m_280046_(startX, startY, startX + 16, startY + totalHeight, 0, -1996488705);
            }
        }
        poseStack.m_85849_();
    }

    public static void renderFluidStackInGUI(Matrix4f matrix, FluidStack fluid, int width, int height, float x, float y) {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        FluidType attributes = fluid.getFluid().getFluidType();
        TextureAtlasSprite FLUID = RenderUtil.getBlockSprite(IClientFluidTypeExtensions.of((Fluid)fluid.getFluid()).getStillTexture(fluid));
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        int color = IClientFluidTypeExtensions.of((Fluid)fluid.getFluid()).getTintColor(fluid);
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)a);
        int wFloors = width / 16;
        int extraWidth = wFloors == 0 ? width : width % 16;
        int hFloors = height / 16;
        int extraHeight = hFloors == 0 ? height : height % 16;
        extraHeight = Math.max(1, extraHeight);
        if (height == 16) {
            extraHeight = 0;
        }
        RenderSystem.setShader(GameRenderer::m_172817_);
        float u0 = FLUID.m_118409_();
        float v0 = FLUID.m_118411_();
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder builder = tessellator.m_85915_();
        for (int i = hFloors; i >= 0 && (i != 0 || extraHeight != 0); --i) {
            float yStart = y - (float)((hFloors - i) * 16);
            float yOffset = i == 0 ? (float)extraHeight : 16.0f;
            float v1 = i == 0 ? FLUID.m_118411_() + (FLUID.m_118412_() - v0) * ((float)extraHeight / 16.0f) : FLUID.m_118412_();
            for (int j = wFloors; j >= 0 && (j != 0 || extraWidth != 0); --j) {
                float xStart = x + (float)((wFloors - j) * 16);
                float xOffset = j == 0 ? (float)extraWidth : 16.0f;
                float u1 = j == 0 ? FLUID.m_118409_() + (FLUID.m_118410_() - u0) * ((float)extraWidth / 16.0f) : FLUID.m_118410_();
                builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                RenderUtil.buildMatrix(matrix, (VertexConsumer)builder, xStart, yStart - yOffset, 0.0f, u0, v0, color);
                RenderUtil.buildMatrix(matrix, (VertexConsumer)builder, xStart, yStart, 0.0f, u0, v1, color);
                RenderUtil.buildMatrix(matrix, (VertexConsumer)builder, xStart + xOffset, yStart, 0.0f, u1, v1, color);
                RenderUtil.buildMatrix(matrix, (VertexConsumer)builder, xStart + xOffset, yStart - yOffset, 0.0f, u1, v0, color);
                tessellator.m_85914_();
            }
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }
}

